/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.step.core.fields;

import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWParameter;
import filenet.vw.api.VWStepElement;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.step.core.fields.VWFieldValue;
import filenet.vw.toolkit.runtime.step.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.IVWTableOperation;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class VWFieldTableModel
extends AbstractTableModel
implements IVWTableOperation {
    private static final int COL_COUNT = 3;
    public static final int COL_NAME = 0;
    public static final int COL_TYPE = 1;
    public static final int COL_VALUE = 2;
    private Vector m_rowCache = null;
    private VWStepElement m_vwStepElement = null;

    public VWFieldTableModel(VWStepElement stepElement) {
        VWParameter[] fields = null;
        try {
            this.m_vwStepElement = stepElement;
            fields = this.getFields();
            this.retrieveRowData(fields);
            this.fireTableChanged(null);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void openItem(int rowIndex) {
    }

    public void refresh() {
    }

    public int getColumnCount() {
        return 3;
    }

    public Class getColumnClass(int index) {
        switch (index) {
            case 0: {
                return VWParameter.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return VWFieldValue.class;
            }
        }
        return null;
    }

    public String getColumnName(int index) {
        switch (index) {
            case 0: {
                return VWResource.s_name;
            }
            case 1: {
                return VWResource.s_type;
            }
            case 2: {
                return VWResource.s_value;
            }
        }
        return null;
    }

    public int getRowCount() {
        return this.m_rowCache.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Object cellObject = this.getCellElement(rowIndex, columnIndex);
        if (cellObject instanceof VWFieldValue) {
            return ((VWFieldValue)cellObject).getValue();
        }
        return cellObject;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        Object cellData = this.getCellElement(rowIndex, columnIndex);
        if (cellData != null && cellData instanceof VWFieldValue) {
            if (((VWFieldValue)cellData).getParameter().isArray()) {
                return true;
            }
            return ((VWFieldValue)cellData).isEditable();
        }
        return false;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.setCellElement(aValue, rowIndex, columnIndex);
    }

    protected void retrieveRowData(VWParameter[] fields) {
        VWParameter vwParameter = null;
        try {
            this.m_rowCache = new Vector();
            if (fields == null) {
                return;
            }
            for (int i = 0; i < fields.length; ++i) {
                vwParameter = fields[i];
                Object[] rowData = new Object[this.getColumnCount()];
                rowData[0] = vwParameter;
                rowData[1] = VWFieldType.getLocalizedString(vwParameter.getFieldType());
                rowData[2] = new VWFieldValue(vwParameter);
                if (vwParameter.isArray()) {
                    rowData[1] = rowData[1] + "[ ]";
                }
                this.m_rowCache.addElement(rowData);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected Object getCellElement(int rowIndex, int columnIndex) {
        if (rowIndex > this.getRowCount() - 1) {
            return null;
        }
        if (columnIndex > this.getColumnCount() - 1) {
            return null;
        }
        return ((Object[])this.m_rowCache.elementAt(rowIndex))[columnIndex];
    }

    protected void setCellElement(Object aValue, int rowIndex, int columnIndex) {
        Object parameter = null;
        try {
            if (rowIndex > this.getRowCount() - 1) {
                return;
            }
            if (columnIndex > this.getColumnCount() - 1) {
                return;
            }
            Object cellData = this.getCellElement(rowIndex, columnIndex);
            if (cellData != null && cellData instanceof VWFieldValue) {
                ((VWFieldValue)cellData).setValue(aValue);
                parameter = this.getCellElement(rowIndex, 0);
                if (parameter instanceof VWParameter) {
                    this.m_vwStepElement.setParameterValue(((VWParameter)parameter).getName(), aValue, true);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected VWParameter[] getFields() {
        try {
            if (this.m_vwStepElement == null) {
                return null;
            }
            Vector<Object> fields = new Vector<Object>();
            Object[] fieldArray = this.m_vwStepElement.getParameters(671, 1);
            if (this.m_vwStepElement.hasParameterName("F_CaseFolder")) {
                fields.add(this.m_vwStepElement.getParameter("F_CaseFolder"));
            }
            if (this.m_vwStepElement.hasParameterName("F_CaseTask")) {
                fields.add(this.m_vwStepElement.getParameter("F_CaseTask"));
            }
            if (fieldArray.length > 0) {
                for (int j = 0; j < fieldArray.length; ++j) {
                    String fieldName = fieldArray[j].getName();
                    boolean bInserted = false;
                    for (int i = 0; i < fields.size(); ++i) {
                        VWParameter tempParameter = (VWParameter)fields.elementAt(i);
                        if (VWStringUtils.compare(fieldName, tempParameter.getName()) >= 0) continue;
                        fields.insertElementAt(fieldArray[j], i);
                        bInserted = true;
                        break;
                    }
                    if (bInserted) continue;
                    fields.addElement(fieldArray[j]);
                }
            }
            if (fields.size() > 0) {
                fieldArray = new VWParameter[fields.size()];
                fields.copyInto(fieldArray);
            }
            return fieldArray;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }
}

